# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY WYMAGANE
# Konieczne jest podanie wartości dla każdego z tych parametrów.
# ---------------------------------------------------------------------------------------------------------------------

variable "name" {
  description = "Nazwa używana przez wszystkie zasoby tworzone przez ten moduł"
  type        = string
}

variable "image" {
  description = "Obraz Dockera przeznaczony do uruchomienia"
  type        = string
}

variable "container_port" {
  description = "Port, na którym nasłuchuje obraz Dockera"
  type        = number
}

variable "replicas" {
  description = "Liczba replik do uruchomienia"
  type        = number
}

# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY OPCJONALNE
# Te parametry mają rozsądne wartości domyślne.
# ---------------------------------------------------------------------------------------------------------------------

variable "environment_variables" {
  description = "Zmienne środowiskowe do zdefiniowania dla aplikacji"
  type        = map(string)
  default     = {}
}
